/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames.command;

import com.google.common.base.Throwables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.overlordsiii.villagernames.VillagerNames;
import io.github.overlordsiii.villagernames.command.suggestion.FormattingSuggestionProvider;
import io.github.overlordsiii.villagernames.command.suggestion.NameSuggestionProvider;
import io.github.overlordsiii.villagernames.config.FormattingDummy;
import io.github.overlordsiii.villagernames.config.GolemNamesConfig;
import io.github.overlordsiii.villagernames.config.PiglinNamesConfig;
import io.github.overlordsiii.villagernames.config.PiglinSurnamesConfig;
import io.github.overlordsiii.villagernames.config.SureNamesConfig;
import io.github.overlordsiii.villagernames.config.VillagerGeneralConfig;
import io.github.overlordsiii.villagernames.config.VillagerNamesConfig;
import java.lang.reflect.Field;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class VillagerNameCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"villagername").requires(source -> VillagerNames.CONFIG.villagerGeneralConfig.needsOP ? source.method_9259(2) : source.method_9259(4))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle").then(class_2170.method_9247((String)"professionNames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "professionNames", "Profession names are now toggled %s")))).then(class_2170.method_9247((String)"golemNames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "golemNames", "Golem Names are now toggled %s")))).then(class_2170.method_9247((String)"needsOP").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "needsOP", "The VillagerNames commands that need op are now toggled %s")))).then(class_2170.method_9247((String)"childNames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "childNames", "Children Having names is now toggled %s")))).then(class_2170.method_9247((String)"turnOffConsoleSpam").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "turnOffVillagerConsoleSpam", "Villagers dying spamming the console is now toggled %s")))).then(class_2170.method_9247((String)"wanderingTraderNames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "wanderingTraderNames", "Wandering Traders having names is now toggled %s")))).then(class_2170.method_9247((String)"surnames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "surNames", "Villager Last Names is now toggled %s")))).then(class_2170.method_9247((String)"reverseLastNames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "reverseLastNames", "Reverse Villager Last Names is now toggled %s")))).then(class_2170.method_9247((String)"nameTagNames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "nameTagNames", "Name Tag Names is now toggled to %s")))).then(class_2170.method_9247((String)"piglinNames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "piglinNames", "Piglin Names is now toggled to %s")))).then(class_2170.method_9247((String)"piglinSurnames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "pillagerSurenames", "Piglin Surnames is now toggled to %s")))).then(class_2170.method_9247((String)"illagerEntityNames").executes(context -> VillagerNameCommand.executeToggle((CommandContext<class_2168>)context, "illagerEntityNames", "Illager Entity Names is not toggled to %s"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"villagerNames").then(class_2170.method_9244((String)"villagerName", (ArgumentType)StringArgumentType.greedyString()).executes(context -> VillagerNameCommand.executeAdd((CommandContext<class_2168>)context, VillagerNames.CONFIG.villagerNamesConfig.villagerNames, StringArgumentType.getString((CommandContext)context, (String)"villagerName"), "Added %s to the villager names list", "villagerNames"))))).then(class_2170.method_9247((String)"golemNames").then(class_2170.method_9244((String)"golemName", (ArgumentType)StringArgumentType.greedyString()).executes(context -> VillagerNameCommand.executeAdd((CommandContext<class_2168>)context, VillagerNames.CONFIG.golemNamesConfig.golemNames, StringArgumentType.getString((CommandContext)context, (String)"golemName"), "Added %s to the golem names list", "golemNames"))))).then(class_2170.method_9247((String)"sureNames").then(class_2170.method_9244((String)"sureName", (ArgumentType)StringArgumentType.greedyString()).executes(context -> VillagerNameCommand.executeAdd((CommandContext<class_2168>)context, VillagerNames.CONFIG.sureNamesConfig.sureNames, StringArgumentType.getString((CommandContext)context, (String)"sureName"), "Added %s to the surename names list", "sureNames"))))).then(class_2170.method_9247((String)"piglinNames").then(class_2170.method_9244((String)"piglinName", (ArgumentType)StringArgumentType.greedyString()).executes(context -> VillagerNameCommand.executeAdd((CommandContext<class_2168>)context, VillagerNames.CONFIG.piglinNamesConfig.piglinNames, StringArgumentType.getString((CommandContext)context, (String)"piglinName"), "Added %s to the piglin names list", "piglinNames"))))).then(class_2170.method_9247((String)"piglinSurnames").then(class_2170.method_9244((String)"piglinSurname", (ArgumentType)StringArgumentType.greedyString()).executes(context -> VillagerNameCommand.executeAdd((CommandContext<class_2168>)context, VillagerNames.CONFIG.piglinSurnamesConfig.piglinSurnames, StringArgumentType.getString((CommandContext)context, (String)"pillagerSurname"), "Added %s to the piglin surnames list", "piglinSurnames")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9247((String)"villagerNames").then(class_2170.method_9244((String)"villagerNam", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new NameSuggestionProvider.Villager()).executes(context -> VillagerNameCommand.executeRemove((CommandContext<class_2168>)context, VillagerNames.CONFIG.villagerNamesConfig.villagerNames, StringArgumentType.getString((CommandContext)context, (String)"villagerNam"), "Removed %s from the villager names list", "villagerNames"))))).then(class_2170.method_9247((String)"golemNames").then(class_2170.method_9244((String)"golemNam", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new NameSuggestionProvider.Golem()).executes(context -> VillagerNameCommand.executeRemove((CommandContext<class_2168>)context, VillagerNames.CONFIG.golemNamesConfig.golemNames, StringArgumentType.getString((CommandContext)context, (String)"golemNam"), "Removed %s from the golem names list", "golemNames"))))).then(class_2170.method_9247((String)"sureNames").then(class_2170.method_9244((String)"sureName", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new NameSuggestionProvider.Surename()).executes(context -> VillagerNameCommand.executeRemove((CommandContext<class_2168>)context, VillagerNames.CONFIG.sureNamesConfig.sureNames, StringArgumentType.getString((CommandContext)context, (String)"sureName"), "Removed %s from the sure names list", "sureNames"))))).then(class_2170.method_9247((String)"piglinNames").then(class_2170.method_9244((String)"piglinName", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new NameSuggestionProvider.Piglin()).executes(context -> VillagerNameCommand.executeRemove((CommandContext<class_2168>)context, VillagerNames.CONFIG.piglinNamesConfig.piglinNames, StringArgumentType.getString((CommandContext)context, (String)"piglinName"), "Removed %s from the piglin names list", "piglinNames"))))).then(class_2170.method_9247((String)"piglinSurnames").then(class_2170.method_9244((String)"piglinSurname", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new NameSuggestionProvider.PiglinSurname()).executes(context -> VillagerNameCommand.executeRemove((CommandContext<class_2168>)context, VillagerNames.CONFIG.piglinSurnamesConfig.piglinSurnames, StringArgumentType.getString((CommandContext)context, (String)"piglinSurname"), "Removed %s from the piglin surnames list", "piginSurnames")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"nitwitText").then(class_2170.method_9244((String)"nitwit", (ArgumentType)StringArgumentType.greedyString()).executes(context -> VillagerNameCommand.executeSetString((CommandContext<class_2168>)context, "nitwitText", StringArgumentType.getString((CommandContext)context, (String)"nitwit"), "The nitwit Text is now set to '%s'"))))).then(class_2170.method_9247((String)"villagerTextFormat").then(class_2170.method_9244((String)"format", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new FormattingSuggestionProvider()).executes(context -> VillagerNameCommand.executeSetFormatting((CommandContext<class_2168>)context, "The villager Text formatting is now set to %s", StringArgumentType.getString((CommandContext)context, (String)"format")))))).then(class_2170.method_9247((String)"wanderingTraderText").then(class_2170.method_9244((String)"wanderingText", (ArgumentType)StringArgumentType.greedyString()).executes(context -> VillagerNameCommand.executeSetString((CommandContext<class_2168>)context, "wanderingTraderText", StringArgumentType.getString((CommandContext)context, (String)"wanderingText"), "The Wandering Trader Text is now set to '%s'")))))).then(class_2170.method_9247((String)"info").executes(VillagerNameCommand::executeInfo)));
    }

    private static int executeSetFormatting(CommandContext<class_2168> ctx, String displayText, String format) throws CommandSyntaxException {
        class_124 newFormatting;
        try {
            newFormatting = class_124.valueOf((String)format);
        }
        catch (Exception e) {
            ((class_2168)ctx.getSource()).method_9207().method_7353((class_2561)new class_2585("ha nice one, but you can't set the formatting to some random formatting. Stick with what the command suggests to you").method_27692(class_124.field_1076), false);
            return -1;
        }
        VillagerNames.CONFIG.villagerGeneralConfig.villagerTextFormatting = FormattingDummy.fromFormatting(newFormatting);
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(String.format(displayText, new Object[]{FormattingDummy.fromFormatting(newFormatting)})).method_27692(newFormatting == class_124.field_1051 ? class_124.field_1068 : newFormatting).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/villagername set villagerTextFormat " + FormattingDummy.fromFormatting(newFormatting).toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(FormattingDummy.fromFormatting(newFormatting).toString()).method_27692(newFormatting)))), true);
        VillagerNames.CONFIG_MANAGER.save();
        try {
            VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.SET, VillagerGeneralConfig.class.getDeclaredField("villagerTextFormatting"), ((class_2168)ctx.getSource()).method_9207(), null);
        }
        catch (Exception e) {
            VillagerNameCommand.logError(ctx, e);
        }
        return 1;
    }

    private static int executeSetString(CommandContext<class_2168> ctx, String literal, String newvalue, String displayedText) throws CommandSyntaxException {
        switch (literal) {
            case "nitwitText": {
                VillagerNames.CONFIG.villagerGeneralConfig.nitwitText = newvalue;
            }
            case "wanderingTraderText": {
                VillagerNames.CONFIG.villagerGeneralConfig.wanderingTraderText = newvalue;
            }
        }
        String text = String.format(displayedText, newvalue);
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(text).method_27692(class_124.field_1076).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("/villagername set " + literal + " " + newvalue))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/villagername set " + literal))), true);
        VillagerNames.CONFIG_MANAGER.save();
        try {
            VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.SET, VillagerGeneralConfig.class.getDeclaredField(literal), ((class_2168)ctx.getSource()).method_9207(), null);
        }
        catch (Exception e) {
            VillagerNameCommand.logError(ctx, e);
        }
        return 1;
    }

    private static int executeToggle(CommandContext<class_2168> ctx, String literal, String displayText) throws CommandSyntaxException {
        String onOrOff;
        try {
            Field field = VillagerGeneralConfig.class.getField(literal);
            boolean newValue = !field.getBoolean(VillagerNames.CONFIG.villagerGeneralConfig);
            field.setBoolean(VillagerNames.CONFIG.villagerGeneralConfig, newValue);
            onOrOff = VillagerNameCommand.parseBoolean(newValue);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            VillagerNameCommand.logError(ctx, e);
            return -1;
        }
        String text = String.format(displayText, onOrOff);
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(text).method_27692(class_124.field_1054).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/villagername toggle " + literal)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("Toggle the " + literal + " rule")))), true);
        VillagerNames.CONFIG_MANAGER.save();
        try {
            VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.TOGGLE, VillagerGeneralConfig.class.getDeclaredField(literal), ((class_2168)ctx.getSource()).method_9207(), null);
        }
        catch (Exception e) {
            VillagerNameCommand.logError(ctx, e);
        }
        return 1;
    }

    private static int executeAdd(CommandContext<class_2168> ctx, List<String> listToAddTo, String toAdd, String displayText, String literal) throws CommandSyntaxException {
        if (!listToAddTo.contains(toAdd)) {
            listToAddTo.add(toAdd);
            String text = String.format(displayText, toAdd);
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(text).method_27692(class_124.field_1075).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("Add an item to the villager or golem list"))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/villagername add " + literal + " " + toAdd))), true);
        } else {
            ((class_2168)ctx.getSource()).method_9207().method_7353((class_2561)new class_2585("The villager or golem list you tried to add too already had that name in it").method_27692(class_124.field_1061), false);
        }
        try {
            if (literal.contains("villagerNames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.ADD, VillagerNamesConfig.class.getDeclaredField(literal), ((class_2168)ctx.getSource()).method_9207(), toAdd);
            } else if (literal.contains("golemNames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.ADD, GolemNamesConfig.class.getDeclaredField(literal), ((class_2168)ctx.getSource()).method_9207(), toAdd);
            } else if (literal.contains("sureNames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.ADD, SureNamesConfig.class.getDeclaredField(literal), ((class_2168)ctx.getSource()).method_9207(), toAdd);
            } else if (literal.contains("piglinNames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.ADD, PiglinNamesConfig.class.getDeclaredField(literal), ((class_2168)ctx.getSource()).method_9207(), toAdd);
            } else if (literal.contains("piglinSurnames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.ADD, PiglinSurnamesConfig.class.getDeclaredField(literal), ((class_2168)ctx.getSource()).method_9207(), toAdd);
            }
        }
        catch (Exception e) {
            VillagerNameCommand.logError(ctx, e);
        }
        VillagerNames.CONFIG_MANAGER.save();
        return 1;
    }

    private static int executeRemove(CommandContext<class_2168> ctx, List<String> listToRemoveFrom, String toRemove, String displayText, String name) throws CommandSyntaxException {
        if (listToRemoveFrom.contains(toRemove)) {
            listToRemoveFrom.remove(toRemove);
            String text = String.format(displayText, toRemove);
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(text).method_27692(class_124.field_1065).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("Remove a name from the villager or golem name list"))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/villagername remove " + name + " " + toRemove))), true);
        } else {
            ((class_2168)ctx.getSource()).method_9207().method_7353((class_2561)new class_2585("The villager or golem list you tried to remove from does not have that name").method_27692(class_124.field_1061), false);
        }
        try {
            if (name.contains("villagerNames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.REMOVE, VillagerNamesConfig.class.getDeclaredField(name), ((class_2168)ctx.getSource()).method_9207(), toRemove);
            } else if (name.contains("golemNames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.REMOVE, GolemNamesConfig.class.getDeclaredField(name), ((class_2168)ctx.getSource()).method_9207(), toRemove);
            } else if (name.contains("sureNames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.REMOVE, SureNamesConfig.class.getDeclaredField(name), ((class_2168)ctx.getSource()).method_9207(), toRemove);
            } else if (name.contains("piglinNames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.REMOVE, PiglinNamesConfig.class.getDeclaredField(name), ((class_2168)ctx.getSource()).method_9207(), toRemove);
            } else if (name.contains("piglinSurnames")) {
                VillagerNameCommand.broadCastConfigChangeToOps(ctx, ConfigChange.REMOVE, PiglinSurnamesConfig.class.getDeclaredField(name), ((class_2168)ctx.getSource()).method_9207(), toRemove);
            }
        }
        catch (Exception e) {
            VillagerNameCommand.logError(ctx, e);
        }
        VillagerNames.CONFIG_MANAGER.save();
        return 1;
    }

    private static int executeInfo(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        try {
            for (Field field : VillagerGeneralConfig.class.getDeclaredFields()) {
                ((class_2168)ctx.getSource()).method_9207().method_7353((class_2561)new class_2585(field.getName() + " = " + field.get(VillagerNames.CONFIG.villagerGeneralConfig).toString()).method_27694(style -> style.method_10958(FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? new class_2558(class_2558.class_2559.field_11746, FabricLoader.getInstance().getConfigDir() + "\\VillagerNames\\villagerRules.json") : new class_2558(class_2558.class_2559.field_11745, "/villagername info"))), false);
            }
        }
        catch (CommandSyntaxException | IllegalAccessException ex) {
            VillagerNameCommand.logError(ctx, (Exception)ex);
        }
        return 1;
    }

    private static void broadCastConfigChangeToOps(CommandContext<class_2168> ctx, ConfigChange change, Field field, class_3222 executor, @Nullable String addedItem) throws IllegalAccessException {
        class_2585 text = switch (change) {
            case ConfigChange.SET -> (class_2585)new class_2585("The " + field.getName() + " has been set to \"" + field.get(VillagerNames.CONFIG.villagerGeneralConfig).toString() + "\" by " + executor.method_5477().method_10851() + ".").method_27692(field.getName().equals("villagerTextFormatting") ? FormattingDummy.valueOf(field.get(VillagerNames.CONFIG.villagerGeneralConfig).toString()).getFormatting() : class_124.field_1076);
            case ConfigChange.ADD -> (class_2585)new class_2585("The " + field.getName() + " has had the name \"" + addedItem + "\" added to the " + field.getName() + " by " + executor.method_5477().method_10851() + ".").method_27692(class_124.field_1075);
            case ConfigChange.TOGGLE -> (class_2585)new class_2585("The " + field.getName() + " has been toggled to " + field.get(VillagerNames.CONFIG.villagerGeneralConfig).toString() + " by " + executor.method_5477().method_10851() + ".").method_27692(class_124.field_1080);
            case ConfigChange.REMOVE -> (class_2585)new class_2585("The " + field.getName() + " has had the name \"" + addedItem + "\" removed from it by " + executor.method_5477().method_10851() + ".").method_27692(class_124.field_1054);
            default -> throw new IllegalStateException("Unexpected value: " + change);
        };
        VillagerNameCommand.addConfigText(text);
        VillagerNameCommand.sendToOps(ctx, (class_2561)text);
    }

    private static void addConfigText(class_2585 text) {
        text.method_10852((class_2561)new class_2585(" Any changes to the config require a server restart.").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080})).method_10852((class_2561)new class_2585(" Would you like to restart the server?").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/stop")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("\u26a0 WARNING! YOU HAVE TO RESTART THE SERVER BY YOURSELF! \u26a0").method_27692(class_124.field_1061)))));
    }

    private static void sendToOps(CommandContext<class_2168> ctx, class_2561 text) {
        ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571().forEach(serverPlayerEntity -> {
            if (((class_2168)ctx.getSource()).method_9211().method_3760().method_14569(serverPlayerEntity.method_7334())) {
                serverPlayerEntity.method_7353(text, false);
            }
        });
    }

    private static String parseBoolean(boolean rule) {
        if (rule) {
            return "on";
        }
        return "off";
    }

    private static void logError(CommandContext<class_2168> ctx, Exception e) throws CommandSyntaxException {
        ((class_2168)ctx.getSource()).method_9207().method_7353((class_2561)new class_2585("Exception Thrown! Exception: " + Throwables.getRootCause((Throwable)e)), false);
        e.printStackTrace();
    }

    public static enum ConfigChange {
        SET,
        TOGGLE,
        ADD,
        REMOVE;

    }
}

